document.addEventListener('DOMContentLoaded', function () {
  new Swiper('.home-slider .swiper', {
    loop: true,
    autoplay: {
      delay: 4000,
      disableOnInteraction: false,
    },
  });
});

let menuToggle = document.querySelector('.menu-toggle');
let menu = document.querySelector('#primary-menu');

menuToggle.addEventListener('click', function () {
  menu.classList.toggle('active');
});
document.addEventListener('click', function (event) {
  if (!menu.contains(event.target) && !menuToggle.contains(event.target)) {
    menu.classList.remove('active');
  }
});

document.addEventListener('DOMContentLoaded', function () {
  const dropdownToggles = document.querySelectorAll('.dropdown-toggle-custom');

  dropdownToggles.forEach(function (toggle) {
    toggle.addEventListener('click', function () {
      const dropdownMenu = this.nextElementSibling;
      dropdownMenu.classList.toggle('show');
    });
  });
});

jQuery(document).ajaxSuccess(function (event, xhr, settings) {
  if (settings.data && settings.data.indexOf('action=ajax_add_to_cart') !== -1) {
    jQuery('.cart-sidebar').addClass('active')
  }
  // sidebar-close
  jQuery('.sidebar-close').on('click', function () {
    jQuery('.cart-sidebar').removeClass('active');
  });
  // Close sidebar when clicking outside
  jQuery(document).on('click', function (e) {
    if (!jQuery(e.target).closest('.cart-sidebar, .sidebar-toggle').length) {
      jQuery('.cart-sidebar').removeClass('active');
    }
  });
});

jQuery(document).ready(function ($) {
  // Tabs functionality
  $('.tabs li').on('click', function () {
    var tab_id = $(this).data('tab');
    $('.tabs li').removeClass('active');
    $('.tab-content').removeClass('active');
    $(this).addClass('active');
    $('#' + tab_id).addClass('active');
  });

  // Quantity controls
  $('.increase').on('click', function () {
    var input = $(this).siblings('.quantity-input');
    input.val(parseInt(input.val(), 10) + 1);
  });

  $('.decrease').on('click', function () {
    var input = $(this).siblings('.quantity-input');
    var current = parseInt(input.val(), 10);
    if (current > 1) {
      input.val(current - 1);
    }
  });

  // AJAX add to cart
  $('.ajax-add-to-cart').on('click', function (e) {
    e.preventDefault();
    var button = $(this);
    var product_id = button.data('product_id');
    var quantity = button.siblings('.quantity-selector').find('.quantity-input').val();

    $.ajax({
      type: 'POST',
      url: (typeof ajaxurl !== 'undefined' ? ajaxurl : '/lujain/wp-admin/admin-ajax.php'),
      data: {
        action: 'ajax_add_to_cart',
        product_id: product_id,
        quantity: quantity
      },
      beforeSend: function () {
        button.prop('disabled', true);
      },
      success: function (response) {
        if (response.success) {
          button.text('تم اضافة المنتج إلى السلة');
          // Optionally update cart counter here
        } else {
          alert('خطأ في إضافة المنتج إلى السلة');
        }
      },
      complete: function () {
        button.prop('disabled', false);
      }
    });
  });
});


let testimonialSwiper = new Swiper('.testimonials-slider', {
  loop: true,
  autoplay: {
    delay: 5000,
    disableOnInteraction: false,
  },
  breakpoints: {
    768: {
      slidesPerView: 2,
      spaceBetween: 20,
    },
    1024: {
      slidesPerView: 2,
      spaceBetween: 30,
    },
  }
});

let partnersSwiper = new Swiper('.partners-slider', {
  loop: true,
  autoplay: {
    delay: 5000,
    disableOnInteraction: false,
  },
  breakpoints: {
    768: {
      slidesPerView: 4,
      spaceBetween: 20,
    },
    1024: {
      slidesPerView: 4,
      spaceBetween: 30,
    },
    1200: {
      slidesPerView: 6,
      spaceBetween: 40,
    },
  }
});

document.addEventListener('DOMContentLoaded', function () {
  const searchToggle = document.querySelector('.search-toggle');
  const searchForm = document.querySelector('.search-form');

  searchToggle.addEventListener('click', function () {
    searchForm.classList.toggle('active');
  });
});