<?php
$options = get_option('theme_options');

?>

<?php 
$whatsapp_number = '+966537776073'; // Replace with your WhatsApp number
?>
<div id="whatsapp-icon">
  <a href="https://wa.me/<?php echo preg_replace('/\D/', '', $whatsapp_number); ?>" target="_blank">
    <i class="fab fa-whatsapp"></i>
  </a>
</div>

<footer id="colophon" class="site-footer">
  <div class="top">
    <div class="container">
      <div class="row">
        <div class="col-md-3">
          <div class="footer-item">
            <figure><img src="<?php echo esc_url( get_theme_file_uri( '/assets/images/Logo.png' ) ); ?>"
                alt="<?php bloginfo( 'name' ); ?>"></figure>
            <div class="social">
              <ul>
                <?php if ($options['instagram_link']) : ?>
                <li><a href="<?= esc_url($options['instagram_link']); ?>" target="_blank"><i
                      class="fab fa-instagram"></i></a>
                </li>
                <?php endif; ?>
                <?php if ($options['linkedin_link']) : ?>
                <li><a href="<?= esc_url($options['linkedin_link']); ?>" target="_blank"><i
                      class="fab fa-linkedin-in"></i></a>
                </li>
                <?php endif; ?>
                <?php if ($options['x_link']) : ?>
                <li><a href="<?= esc_url($options['x_link']); ?>" target="_blank"><i class="fab fa-x-twitter"></i></a>
                </li>
                <?php endif; ?>
                <?php if ($options['facebook_link']) : ?>
                <li><a href="<?= esc_url($options['facebook_link']); ?>" target="_blank"><i
                      class="fab fa-facebook-f"></i></a>
                </li>
                <?php endif; ?>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="footer-item">
            <h3>روابط سريعة</h3>
            <?php wp_nav_menu( 
					array(
						'theme_location' => 'menu-2',
						'menu_id'        => 'footer-menu-1',
						'menu_class'     => 'footer-menu',
						'container'      => false,
						)
					);
					?>
          </div>
        </div>
        <div class="col-md-3">
          <div class="footer-item">
            <h3>روابط هامة</h3>
            <?php wp_nav_menu( 
									array(
										'theme_location' => 'menu-3',
										'menu_id'        => 'footer-menu-2',
										'menu_class'     => 'footer-menu',
										'container'      => false,
							)
						);
						?>
          </div>
        </div>
        <div class="col-md-3">
          <div class="footer-item">
            <h3>تواصل معنا</h3>
            <p class="mb-2">
              <svg width="10" height="12" viewBox="0 0 10 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M8.7678 11.1087H6.143C6.58393 10.715 6.99974 10.294 7.388 9.84831C8.84475 8.17292 9.61691 6.40677 9.61691 4.7404C9.61691 3.50182 9.12489 2.31396 8.24907 1.43815C7.37326 0.562338 6.18541 0.0703125 4.94682 0.0703125C3.70824 0.0703125 2.52038 0.562338 1.64457 1.43815C0.768759 2.31396 0.276733 3.50182 0.276733 4.7404C0.276733 6.40677 1.04677 8.17292 2.50564 9.84831C2.8939 10.294 3.30972 10.715 3.75064 11.1087H1.12584C1.01324 11.1087 0.905255 11.1534 0.825636 11.2331C0.746017 11.3127 0.701287 11.4207 0.701287 11.5333C0.701287 11.6459 0.746017 11.7538 0.825636 11.8335C0.905255 11.9131 1.01324 11.9578 1.12584 11.9578H8.7678C8.8804 11.9578 8.98839 11.9131 9.06801 11.8335C9.14763 11.7538 9.19236 11.6459 9.19236 11.5333C9.19236 11.4207 9.14763 11.3127 9.06801 11.2331C8.98839 11.1534 8.8804 11.1087 8.7678 11.1087ZM1.12584 4.7404C1.12584 3.72701 1.52841 2.75513 2.24498 2.03856C2.96155 1.32199 3.93343 0.91942 4.94682 0.91942C5.96021 0.91942 6.93209 1.32199 7.64866 2.03856C8.36524 2.75513 8.7678 3.72701 8.7678 4.7404C8.7678 7.77755 5.82406 10.3127 4.94682 11.0026C4.06959 10.3127 1.12584 7.77755 1.12584 4.7404ZM7.06959 4.7404C7.06959 4.32056 6.94509 3.91014 6.71184 3.56105C6.47859 3.21197 6.14706 2.93989 5.75917 2.77922C5.37129 2.61855 4.94447 2.57651 4.53269 2.65842C4.12091 2.74033 3.74267 2.9425 3.4458 3.23938C3.14892 3.53625 2.94675 3.91449 2.86484 4.32627C2.78294 4.73805 2.82497 5.16486 2.98564 5.55275C3.14631 5.94063 3.41839 6.27217 3.76748 6.50542C4.11656 6.73867 4.52698 6.86317 4.94682 6.86317C5.50982 6.86317 6.04975 6.63952 6.44785 6.24143C6.84594 5.84333 7.06959 5.30339 7.06959 4.7404ZM3.67316 4.7404C3.67316 4.4885 3.74786 4.24225 3.88781 4.03279C4.02776 3.82334 4.22668 3.66009 4.45941 3.56369C4.69214 3.46729 4.94824 3.44207 5.1953 3.49121C5.44237 3.54036 5.66931 3.66166 5.84744 3.83979C6.02556 4.01791 6.14687 4.24486 6.19601 4.49192C6.24515 4.73899 6.21993 4.99508 6.12353 5.22781C6.02713 5.46054 5.86388 5.65946 5.65443 5.79941C5.44498 5.93936 5.19873 6.01406 4.94682 6.01406C4.60903 6.01406 4.28507 5.87987 4.04621 5.64102C3.80735 5.40216 3.67316 5.0782 3.67316 4.7404Z"
                  fill="#BCCC33" />
              </svg>
              <?=(is_rtl())?$options['company_address']:$options['company_address_en']?>
            </p>
            <p class="mb-2">

              <svg width="12" height="11" viewBox="0 0 12 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M1.13864 7.33844L3.64514 6.21528L3.65206 6.21209C3.78218 6.15643 3.92413 6.1341 4.06506 6.1471C4.20598 6.16011 4.34144 6.20805 4.45918 6.28658C4.47305 6.29573 4.48637 6.30568 4.49909 6.31637L5.7941 7.42038C6.61453 7.02187 7.46156 6.18123 7.86006 5.37144L6.75446 4.05674C6.74382 4.04344 6.73371 4.03014 6.72413 4.01577C6.64729 3.89835 6.60067 3.76375 6.58841 3.62396C6.57616 3.48416 6.59866 3.3435 6.6539 3.2145V3.20812L7.78026 0.697361C7.85329 0.528842 7.97886 0.38846 8.13823 0.297172C8.2976 0.205884 8.48222 0.168587 8.66453 0.190847C9.38547 0.285716 10.0472 0.639777 10.5262 1.1869C11.0052 1.73402 11.2686 2.4368 11.2673 3.16396C11.2673 7.38846 7.83027 10.8255 3.60577 10.8255C2.87861 10.8268 2.17584 10.5634 1.62871 10.0844C1.08159 9.60542 0.727528 8.94366 0.632659 8.22271C0.610358 8.04047 0.647578 7.85589 0.738766 7.69653C0.829953 7.53717 0.970222 7.41156 1.13864 7.33844ZM3.60577 9.97423C5.41136 9.97226 7.14244 9.25412 8.41918 7.97737C9.69593 6.70062 10.4141 4.96955 10.416 3.16396C10.418 2.6444 10.2309 2.14188 9.88945 1.75024C9.54804 1.35861 9.07575 1.10463 8.56078 1.03575C8.56099 1.03787 8.56099 1.04001 8.56078 1.04213L7.44347 3.54278L8.54322 4.85908C8.55438 4.87192 8.56452 4.88562 8.57355 4.90005C8.65361 5.02291 8.70058 5.16437 8.7099 5.31072C8.71923 5.45707 8.69058 5.60334 8.62675 5.73537C8.14471 6.72126 7.15137 7.70716 6.15483 8.18866C6.02184 8.2519 5.87472 8.27955 5.72784 8.26892C5.58096 8.25829 5.43935 8.20974 5.31685 8.12801C5.30319 8.11881 5.29005 8.10886 5.27748 8.09821L3.98406 6.99474L1.48341 8.11471C1.48341 8.11471 1.47916 8.11471 1.47756 8.11471C1.5456 8.63041 1.7992 9.10365 2.19091 9.44591C2.58262 9.78816 3.0856 9.97598 3.60577 9.97423Z"
                  fill="#BCCC33" />
              </svg>
              <?=$options['company_phone']?>
            </p>
            <p class="mb-2">
              <svg width="12" height="9" viewBox="0 0 12 9" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M10.8581 0.680664H1.03561C0.927066 0.680664 0.822967 0.723783 0.746215 0.800536C0.669462 0.877289 0.626343 0.981388 0.626343 1.08993V8.04749C0.626343 8.26458 0.712581 8.47278 0.866087 8.62629C1.01959 8.77979 1.22779 8.86603 1.44488 8.86603H10.4488C10.6659 8.86603 10.8741 8.77979 11.0276 8.62629C11.1811 8.47278 11.2673 8.26458 11.2673 8.04749V1.08993C11.2673 0.981388 11.2242 0.877289 11.1474 0.800536C11.0707 0.723783 10.9666 0.680664 10.8581 0.680664ZM5.94683 5.03681L2.08794 1.4992H9.80572L5.94683 5.03681ZM4.4484 4.77335L1.44488 7.52619V2.02051L4.4484 4.77335ZM5.05412 5.32842L5.66802 5.89372C5.74352 5.96303 5.84229 6.00149 5.94479 6.00149C6.04728 6.00149 6.14605 5.96303 6.22155 5.89372L6.83546 5.32842L9.80265 8.04749H2.08794L5.05412 5.32842ZM7.44527 4.77335L10.4488 2.01999V7.5267L7.44527 4.77335Z"
                  fill="#BCCC33" />
              </svg>
              <?=$options['company_email']?>
            </p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="site-info">
    <div class="container">
      <div class="row">
        <div class="col-md-6">
          <p>جميع الحقوق محفوظة &copy; <?php echo date( 'Y' ); ?></p>
        </div>
        <div class="col-md-6 text-right">
          <a target="_blank" href="https://www.topline.com.sa" title="تطوير توب لاين">
            <img src="https://www.topline.com.sa/logo/topline-logo-dark.png"
              alt="استضافة - تصميم مواقع - برمجة تطبيقات | توب لاين"></a>
        </div>
      </div>
    </div>
  </div><!-- .site-info -->


</footer>


</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>