<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package toplineWooCommerce
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">

  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  <div id="page" class="site">

    <header id="masthead" class="site-header">
      <div class="container">
        <div class="site-logo">
          <?php the_custom_logo(); ?>
        </div>
        <nav id="site-navigation" class="main-navigation">
          <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><i
              class="fa fa-bars"></i></button>
          <?php
						wp_nav_menu(
							array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
							)
						);
						?>
        </nav>
        <div class="header-icons">
          <!-- Contact Icon -->
          <div class="icon contact-icon">
            <a href="<?php echo esc_url( home_url( '/contact' ) ); ?>">
              <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/icons/phone-icon.svg' ); ?>"
                alt="">
            </a>
          </div>

          <!-- My Account Shortcode -->
          <div class="icon account-shortcode">
            <div class="account-dropdown">
              <a href="#" class="dropdown-toggle-custom"><img
                  src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/icons/user-icon.svg' ); ?>"
                  alt=""></a>
              <ul class="dropdown-menu-custom">
                <li>
                  <a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>">
                    <?php esc_html_e( 'تسجيل الدخول', 'toplinewoocommerce' ); ?>
                  </a>
                </li>
                <li>
                  <a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) . '?action=register' ); ?>">
                    <?php esc_html_e( 'تسجيل جديد', 'toplinewoocommerce' ); ?>
                  </a>
                </li>
              </ul>
            </div>
          </div>


          <!-- Cart Shortcode Showing Product Count -->
          <div class="icon cart-shortcode">
            <a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
              <?php
								$cart_count = WC()->cart->get_cart_contents_count();
								echo '<img src="' . esc_url( get_template_directory_uri() . '/assets/images/icons/cart-icon.svg' ) . '" alt="">';
								if ( $cart_count > 0 ) {
									echo '<span class="cart-count">' . esc_html( $cart_count ) . '</span>';
								}
							?>
            </a>
          </div>

          <!-- Search Icon -->
          <div class="icon search-icon">
            <a href="#" class="search-toggle">
              <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/icons/search-icon.svg' ); ?>"
                alt="">
            </a>
          </div>
          <!-- Search Form -->
            <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
              <label>
                <span
                  class="screen-reader-text"><?php echo esc_html_x( 'بحث عن:', 'label', 'toplinewoocommerce' ); ?></span>
                <input type="search" class="search-field"
                  placeholder="<?php echo esc_attr_x( 'ابحث عن منتج...', 'placeholder', 'toplinewoocommerce' ); ?>"
                  value="<?php echo get_search_query(); ?>" name="s"
                  title="<?php echo esc_attr_x( 'بحث عن:', 'label', 'toplinewoocommerce' ); ?>">
              </label>
              <input type="hidden" name="post_type" value="product">
              <button type="submit" class="search-submit">
                <span
                  class="screen-reader-text"><?php echo esc_html_x( 'بحث', 'submit button', 'toplinewoocommerce' ); ?></span>
                <i class="fa fa-search"></i>
              </button>
            </form>

        </div>
      </div>
    </header>

    <aside class="cart-sidebar">
      <div class="d-flex align-items-center justify-content-between header-cart">
        <h2>سلة التسوق</h2>
        <button class="sidebar-close" aria-label="close"><i class="fa fa-times"></i> إغلاق</button>
      </div>
      <div class="cart-items">
        <?php 
        if ( function_exists( 'woocommerce_mini_cart' ) ) { 
          woocommerce_mini_cart(); 
        } 
      ?>
      </div>
    </aside>