<?php

/**

 * Template Name: Home

 */

get_header(); ?>



<main id="main-home">





  <section class="home-slider mb-5">

    <div class="hero">

      <?php

                $args = array(

                    'post_type' => 'slider',

                    'posts_per_page' => 1,

                );

                $slider_query = new WP_Query($args);

                if ($slider_query->have_posts()) :

                    while ($slider_query->have_posts()) : $slider_query->the_post(); ?>

      <div class="slide-content">

        <div class="container position-relative">

          <div class="row align-items-center">

            <div class="col-md-6">

              <div class="inner">

                <h2><?php the_title(); ?></h2>

                <p><?php echo wp_trim_words( get_the_excerpt(), 20, '...' ); ?></p>

                <a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-primary">

                  اطلب الآن

                </a>

              </div>

            </div>

            <div class="col-md-6">

              <figure>

                <?php if (has_post_thumbnail()) : ?>

                <?php the_post_thumbnail(); ?>

                <?php endif; ?>

              </figure>

            </div>

          </div>

        </div>

      </div>

      <?php endwhile;

                endif;

                wp_reset_postdata(); ?>

    </div>

  </section>



  <section class="home-categories">

    <div class="container mb-5">

      <div class="d-flex align-items-center justify-content-between mb-4 header-categories">

        <h2 class="section-title">اللحوم</h2>

        <?php

        // Get subcategories for parent category with term ID 16

        $subcategories = get_terms([

          'taxonomy'   => 'product_cat',

          'parent'     => 16,

          'hide_empty' => false,
          'orderby' => 'name',
          'order'   => 'DESC',

        ]);

        if (!empty($subcategories) && !is_wp_error($subcategories)) :

      ?>

        <ul class="nav nav-tabs" id="myTab" role="tablist">

          <?php foreach ($subcategories as $index => $subcat) : ?>

          <li class="nav-item" role="presentation">

            <button class="nav-link <?php echo $index === 0 ? 'active' : ''; ?>"

              id="tab-<?php echo esc_attr($subcat->term_id); ?>" data-bs-toggle="tab"

              data-bs-target="#tab-<?php echo esc_attr($subcat->term_id); ?>-pane" type="button" role="tab"

              aria-controls="tab-<?php echo esc_attr($subcat->term_id); ?>"

              aria-selected="true"><?php echo esc_html($subcat->name); ?></button>

          </li>

          <?php endforeach; ?>

        </ul>

      </div>



      <div class="tab-content" id="myTabContent">

        <?php foreach ($subcategories as $index => $subcat) : ?>

        <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>"

          id="tab-<?php echo esc_attr($subcat->term_id); ?>-pane" role="tabpanel"

          aria-labelledby="tab-<?php echo esc_attr($subcat->term_id); ?>">

          <div class="products-grid">

            <?php

              $args = [

                'post_type'      => 'product',

                'posts_per_page' => 8,

                'tax_query'      => [

                  [

                    'taxonomy' => 'product_cat',

                    'field'    => 'term_id',

                    'terms'    => $subcat->term_id,

                  ],

                ],

              ];

              $products = new WP_Query($args);

              if ($products->have_posts()) :

                while ($products->have_posts()) : $products->the_post();

                  global $product;

            ?>

            <div class="product-card">

              <div class="product-image">

                <a href="<?php the_permalink(); ?>">

                  <?php echo woocommerce_get_product_thumbnail(); ?>

                </a>

              </div>

              <div class="product-info">

                <h3 class="product-title">

                  <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                </h3>

                <div class="product-price">

                  <?php echo $product->get_price_html(); ?>

                </div>

                <div class="product-actions">

                  <button type="button" class="ajax-add-to-cart"

                    data-product_id="<?php echo esc_attr($product->get_id()); ?>">

                    <img

                      src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/icons/cart-icon.svg'); ?>"

                      alt=""> <span>اضف للسلة</span>

                  </button>

                  <div class="quantity-selector">

                    <button type="button" class="decrease">-</button>

                    <input type="number" class="quantity-input" value="1" min="1">

                    <button type="button" class="increase">+</button>

                  </div>

                </div>

              </div>

            </div>

            <?php

                endwhile;

                wp_reset_postdata();

              else :

                echo '<p>' . esc_html__('No products found', 'your-text-domain') . '</p>';

              endif;

            ?>

          </div>

        </div>

        <?php endforeach; ?>

      </div>

      <?php endif; ?>

    </div>

    <div class="py-5 bg-light">

      <div class="container">

        <div class="d-flex align-items-center justify-content-between mb-4 header-categories">

          <h2 class="section-title">مزارعنا</h2>

          <?php

        // Get subcategories for parent category with term ID 16

        $subcategories = get_terms([

          'taxonomy'   => 'product_cat',

          'parent'     => 21,

          'hide_empty' => false,

        ]);

        if (!empty($subcategories) && !is_wp_error($subcategories)) :

      ?>

          <ul class="nav nav-tabs" id="myTab" role="tablist">

            <?php foreach ($subcategories as $index => $subcat) : ?>

            <li class="nav-item" role="presentation">

              <button class="nav-link <?php echo $index === 0 ? 'active' : ''; ?>"

                id="tab-<?php echo esc_attr($subcat->term_id); ?>" data-bs-toggle="tab"

                data-bs-target="#tab-<?php echo esc_attr($subcat->term_id); ?>-pane" type="button" role="tab"

                aria-controls="tab-<?php echo esc_attr($subcat->term_id); ?>"

                aria-selected="true"><?php echo esc_html($subcat->name); ?></button>

            </li>

            <?php endforeach; ?>

          </ul>

        </div>



        <div class="tab-content" id="myTabContent">

          <?php foreach ($subcategories as $index => $subcat) : ?>

          <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>"

            id="tab-<?php echo esc_attr($subcat->term_id); ?>-pane" role="tabpanel"

            aria-labelledby="tab-<?php echo esc_attr($subcat->term_id); ?>">

            <div class="products-grid">

              <?php

              $args = [

                'post_type'      => 'product',

                'posts_per_page' => 8,

                'tax_query'      => [

                  [

                    'taxonomy' => 'product_cat',

                    'field'    => 'term_id',

                    'terms'    => $subcat->term_id,

                  ],

                ],

              ];

              $products = new WP_Query($args);

              if ($products->have_posts()) :

                while ($products->have_posts()) : $products->the_post();

                  global $product;

            ?>

              <div class="product-card">

                <div class="product-image">

                  <a href="<?php the_permalink(); ?>">

                    <?php echo woocommerce_get_product_thumbnail(); ?>

                  </a>

                </div>

                <div class="product-info">

                  <h3 class="product-title">

                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                  </h3>

                  <div class="product-price">

                    <?php echo $product->get_price_html(); ?>

                  </div>

                  <div class="product-actions">

                    <button type="button" class="ajax-add-to-cart"

                      data-product_id="<?php echo esc_attr($product->get_id()); ?>">

                      <img

                        src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/icons/cart-icon.svg'); ?>"

                        alt=""> <span>اضف للسلة</span>

                    </button>

                    <div class="quantity-selector">

                      <button type="button" class="decrease">-</button>

                      <input type="number" class="quantity-input" value="1" min="1">

                      <button type="button" class="increase">+</button>

                    </div>

                  </div>

                </div>

              </div>

              <?php

                endwhile;

                wp_reset_postdata();

              else :

                echo '<p>' . esc_html__('No products found', 'your-text-domain') . '</p>';

              endif;

            ?>

            </div>

          </div>

          <?php endforeach; ?>

        </div>

        <?php endif; ?>

      </div>

    </div>

    <div class="container mb-5">

      <div class="d-flex align-items-center justify-content-between mb-4 header-categories">

        <h2 class="section-title">منتجاتنا</h2>

        <?php

        // Get subcategories for parent category with term ID 16

        $subcategories = get_terms([

          'taxonomy'   => 'product_cat',

          'parent'     => 28,

          'hide_empty' => false,

        ]);

        if (!empty($subcategories) && !is_wp_error($subcategories)) :

      ?>

        <ul class="nav nav-tabs" id="myTab" role="tablist">

          <?php foreach ($subcategories as $index => $subcat) : ?>

          <li class="nav-item" role="presentation">

            <button class="nav-link <?php echo $index === 0 ? 'active' : ''; ?>"

              id="tab-<?php echo esc_attr($subcat->term_id); ?>" data-bs-toggle="tab"

              data-bs-target="#tab-<?php echo esc_attr($subcat->term_id); ?>-pane" type="button" role="tab"

              aria-controls="tab-<?php echo esc_attr($subcat->term_id); ?>"

              aria-selected="true"><?php echo esc_html($subcat->name); ?></button>

          </li>

          <?php endforeach; ?>

        </ul>

      </div>



      <div class="tab-content" id="myTabContent">

        <?php foreach ($subcategories as $index => $subcat) : ?>

        <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>"

          id="tab-<?php echo esc_attr($subcat->term_id); ?>-pane" role="tabpanel"

          aria-labelledby="tab-<?php echo esc_attr($subcat->term_id); ?>">

          <div class="products-grid">

            <?php

              $args = [

                'post_type'      => 'product',

                'posts_per_page' => 8,

                'tax_query'      => [

                  [

                    'taxonomy' => 'product_cat',

                    'field'    => 'term_id',

                    'terms'    => $subcat->term_id,

                  ],

                ],

              ];

              $products = new WP_Query($args);

              if ($products->have_posts()) :

                while ($products->have_posts()) : $products->the_post();

                  global $product;

            ?>

            <div class="product-card">

              <div class="product-image">

                <a href="<?php the_permalink(); ?>">

                  <?php echo woocommerce_get_product_thumbnail(); ?>

                </a>

              </div>

              <div class="product-info">

                <h3 class="product-title">

                  <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

                </h3>

                <div class="product-price">

                  <?php echo $product->get_price_html(); ?>

                </div>

                <div class="product-actions">

                  <button type="button" class="ajax-add-to-cart"

                    data-product_id="<?php echo esc_attr($product->get_id()); ?>">

                    <img

                      src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/icons/cart-icon.svg'); ?>"

                      alt=""> <span>اضف للسلة</span>

                  </button>

                  <div class="quantity-selector">

                    <button type="button" class="decrease">-</button>

                    <input type="number" class="quantity-input" value="1" min="1">

                    <button type="button" class="increase">+</button>

                  </div>

                </div>

              </div>

            </div>

            <?php

                endwhile;

                wp_reset_postdata();

              else :

                echo '<p>' . esc_html__('No products found', 'your-text-domain') . '</p>';

              endif;

            ?>

          </div>

        </div>

        <?php endforeach; ?>

      </div>

      <?php endif; ?>

    </div>




    <section class="best-sellers py-5">

      <div class="container">

        <h2 class="section-title">الأكثر مبيعا</h2>

        <div class="products-grid">

          <?php

          $args = [

            'post_type'      => 'product',

            'posts_per_page' => 4,

            'meta_key'       => 'total_sales',

            'orderby'        => 'meta_value_num',

            'order'          => 'DESC',

          ];

          $best_sellers = new WP_Query($args);

          if ( $best_sellers->have_posts() ) :

            while ( $best_sellers->have_posts() ) : $best_sellers->the_post();

              global $product;

          ?>

          <div class="product-card">

            <div class="product-image">

              <a href="<?php the_permalink(); ?>">

                <?php echo woocommerce_get_product_thumbnail(); ?>

              </a>

            </div>

            <div class="product-info">

              <h3 class="product-title">

                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

              </h3>

              <div class="product-price">

                <?php echo $product->get_price_html(); ?>

              </div>

              <div class="product-actions">

                <button type="button" class="ajax-add-to-cart"

                  data-product_id="<?php echo esc_attr($product->get_id()); ?>">

                  <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/icons/cart-icon.svg'); ?>"

                    alt="">

                  <span>اضف للسلة</span>

                </button>

                <div class="quantity-selector">

                  <button type="button" class="decrease">-</button>

                  <input type="number" class="quantity-input" value="1" min="1">

                  <button type="button" class="increase">+</button>

                </div>

              </div>

            </div>

          </div>

          <?php

            endwhile;

            wp_reset_postdata();

          else :

            echo '<p>' . esc_html__('لا توجد منتجات', 'your-text-domain') . '</p>';

          endif;

          ?>

        </div>

      </div>

    </section>



    <section class="why-lujain-slaughter">

      <?php

        // استعلام من الصفحة رقم 18

        $page = get_post(18);

        if ($page) :

        $pageTitle   = apply_filters('the_title', $page->post_title);

        $pageContent = apply_filters('the_content', $page->post_content);

        $featuredImage = get_the_post_thumbnail_url($page, 'full');

      ?>

      <div class="row align-items-center">

        <div class="col-md-6 p-0">

          <?php if ($featuredImage) : ?>

          <figure><img src="<?php echo esc_url($featuredImage); ?>" alt="<?php echo esc_attr($pageTitle); ?>"

              class="img-fluid"></figure>

          <?php endif; ?>

        </div>

        <div class="col-md-6 p-0">

          <div class="why-lujain-content">

            <h2 class="section-title mb-4"><?php echo esc_html($pageTitle); ?></h2>

            <div class="page-content">

              <?php echo $pageContent; ?>

            </div>

          </div>

        </div>



      </div>

      <?php endif; ?>

    </section>



    <section class="py-5" id="testimonials">

      <div class="container">

        <h2 class="section-title mb-4">آراء العملاء</h2>

        <div class="swiper testimonials-slider">

          <div class="swiper-wrapper">

            <?php

            $testimonials = new WP_Query([

              'post_type'      => 'testimonial',

              'posts_per_page' => 5,

            ]);

            if ($testimonials->have_posts()) :

              while ($testimonials->have_posts()) : $testimonials->the_post();

              # Get custom field for position

              $position = get_post_meta(get_the_ID(), '_testimonial_position', true);

              ?>

            <div class="swiper-slide">

              <div class="testimonial-card">

                <div class="testimonial-content">

                  <p><?php echo wp_trim_words(get_the_content(), 20, '...'); ?></p>

                </div>

                <div class="testimonial-author">

                  <div class="author-info">

                    <?php if (has_post_thumbnail()) : ?>

                    <figure><?php the_post_thumbnail('thumbnail'); ?></figure>

                    <?php endif; ?>

                    <div>

                      <h3><?php the_title(); ?></h3>

                      <small><?php echo esc_html($position); ?></small>

                    </div>

                  </div>

                </div>

              </div>

            </div>

            <?php

              endwhile;

              wp_reset_postdata();

            endif;

            ?>

          </div>

        </div>

      </div>

    </section>



    <!-- الشركاء -->



    <section class="partners py-5">

      <div class="container">

        <h2 class="section-title mb-4">شركاؤنا</h2>

        <div class="swiper partners-slider">

          <div class="swiper-wrapper">

            <?php

            $partners = new WP_Query([

              'post_type'      => 'partner',

              'posts_per_page' => 10,

            ]);

            if ($partners->have_posts()) :

              while ($partners->have_posts()) : $partners->the_post();

            ?>

            <div class="swiper-slide">

              <div class="partner-card">

                <div class="partner-logo">

                  <?php if (has_post_thumbnail()) : ?>

                  <?php the_post_thumbnail('thumbnail'); ?>

                  <?php else : ?>

                  <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/placeholder.png'); ?>"

                    alt="<?php the_title(); ?>">

                  <?php endif; ?>

                </div>

              </div>

            </div>

            <?php

              endwhile;

              wp_reset_postdata();

            else :

              echo '<p>' . esc_html__('لا توجد شركاء', 'your-text-domain') . '</p>';

            endif;

            ?>

          </div>

        </div>

      </div>

    </section>



  </section>



</main>





<?php get_footer(); ?>