<?php 





// 1. إزالة كل العناصر الافتراضية من الكارد

remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );

remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );



// 2. إضافة صورة المنتج داخل الرابط في بداية الكارد

add_action( 'woocommerce_before_shop_loop_item', function() {

    global $product;

    echo '<a href="' . get_the_permalink( $product->get_id() ) . '" class="product-image">';

    echo woocommerce_get_product_thumbnail();

    echo '</a>';

  }, 10 );

  

  // 3. إضافة عنوان المنتج (بدون لينك)

  add_action( 'woocommerce_after_shop_loop_item', function() {

  global $product;

    echo '<a href="' . get_the_permalink( $product->get_id() ) . '" class="product-title">' . get_the_title() . '</a>';

}, 11 );



// 4. إضافة السعر

add_action( 'woocommerce_after_shop_loop_item', function() {

    global $product;

    echo '<span class="price">' . $product->get_price_html() . '</span>';

}, 12 );



// 5. إضافة زر أضف للسلة

add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 13 );





remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 13 ); // إذا استخدمت الكود السابق، كان عندك 13

// أو استخدم رقم الأولوية الذي أضفته لزر السلة في كودك السابق



add_action( 'woocommerce_after_shop_loop_item', function() {

    global $product;



    if ( ! $product->is_in_stock() ) {

        woocommerce_template_loop_add_to_cart(); // المنتج غير متوفر، لا داعي للفورم

        return;

    }

    ?>

<form class="cart" action="<?php echo esc_url( $product->add_to_cart_url() ); ?>" method="post"
  enctype="multipart/form-data">

  <div class="quantity-buttons">

    <button type="button" class="qty-minus">-</button>

    <input type="number" id="quantity_<?php echo esc_attr( $product->get_id() ); ?>" class="input-text qty text"
      step="1" min="1"
      max="<?php echo ( 0 < $product->get_max_purchase_quantity() ) ? $product->get_max_purchase_quantity() : ''; ?>"
      name="quantity" value="1" title="<?php esc_attr_e( 'Quantity', 'woocommerce' ); ?>" size="4"
      inputmode="numeric" />

    <button type="button" class="qty-plus">+</button>

  </div>

  <button type="submit" class="button add_to_cart_button"><img
      src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/icons/cart-icon.svg'); ?>" alt="">

    <span><?php echo esc_html( $product->add_to_cart_text() ); ?></span></button>

  <input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" />

</form>



<?php

}, 14 );



add_action('wp_footer', function() {

?>

<script>
document.addEventListener('DOMContentLoaded', function() {

  document.querySelectorAll('.quantity-buttons').forEach(function(qtyBox) {

    var minus = qtyBox.querySelector('.qty-minus');

    var plus = qtyBox.querySelector('.qty-plus');

    var input = qtyBox.querySelector('input.qty');



    if (minus) minus.addEventListener('click', function() {

      var val = parseInt(input.value);

      if (val > 1) input.value = val - 1;

    });

    if (plus) plus.addEventListener('click', function() {

      var val = parseInt(input.value);

      input.value = val + 1;

    });

  });

});
</script>

<?php

});



// إيقاف تحميل جميع ستايلات WooCommerce الافتراضية

add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );





// إزالة العرض الافتراضي

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );



// إضافة كلا العنصرين داخل div مخصص

add_action( 'woocommerce_before_shop_loop', function() {

    echo '<div class="shop-toolbar">';

        woocommerce_result_count();

        woocommerce_catalog_ordering();

    echo '</div>';

}, 20 );





// تعطيل التعليقات والمراجعات على المنتجات

add_filter( 'woocommerce_product_review_list_args', '__return_empty_array' );

add_filter( 'woocommerce_product_tabs', 'remove_reviews_tab', 98 );



function remove_reviews_tab($tabs) {

    unset($tabs['reviews']); // يحذف تبويب المراجعات

    return $tabs;

}



add_action('init', 'disable_product_comments');

function disable_product_comments() {

    remove_post_type_support( 'product', 'comments' );

}







// افتح .container و .row قبل الصور

add_action( 'woocommerce_before_single_product_summary', 'start_bootstrap_row_on_single_product', 5 );

function start_bootstrap_row_on_single_product() {

    echo '<div class="container"><div class="row"><div class="col-md-6">';

}



// اغلق عمود الصورة وابدأ عمود المحتوى

add_action( 'woocommerce_before_single_product_summary', 'start_content_column_on_single_product', 25 );

function start_content_column_on_single_product() {

    echo '</div><div class="col-md-6">';

}



// اغلق كل العناصر بعد المحتوى

add_action( 'woocommerce_single_product_summary', 'end_bootstrap_row_on_single_product', 100 );

function end_bootstrap_row_on_single_product() {

    echo '</div></div></div>'; // close col, row, container

}





// إزالة العناصر الافتراضية من ترتيب صفحة المنتج

remove_all_actions( 'woocommerce_single_product_summary' );



// ✅ 1. عرض البريـدكـرمـبـز

// add_action( 'woocommerce_single_product_summary', 'custom_product_breadcrumbs', 1 );

function custom_product_breadcrumbs() {

    echo '<div class="mb-3">';

    woocommerce_breadcrumb();

    echo '</div>';

}



// ✅ 2. عرض العنوان

add_action( 'woocommerce_single_product_summary', function() {

    echo '<h1 class="product-title">' . get_the_title() . '</h1>';

}, 5 );



// ✅ 3. عرض السعر + الوصف + التصنيفات

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 15 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 20 );



// ✅ 4. عرض نموذج الإضافة للسلة مع الكمية

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );





// أضف أزرار + و - إلى حقل الكمية في صفحة المنتج

add_action( 'wp_footer', 'custom_quantity_plus_minus' );

function custom_quantity_plus_minus() {

    if ( ! is_product() ) return;

    ?>

<script>
document.addEventListener('DOMContentLoaded', function() {

  const qtyContainers = document.querySelectorAll('.quantity');



  qtyContainers.forEach(function(container) {

    const input = container.querySelector('input.qty');

    if (!input) return;



    // أزرار +

    const plus = document.createElement('button');

    plus.type = 'button';

    plus.innerHTML = '+';

    plus.classList.add('qty-plus', 'btn', 'btn-outline-secondary');

    container.appendChild(plus);



    // أزرار -

    const minus = document.createElement('button');

    minus.type = 'button';

    minus.innerHTML = '-';

    minus.classList.add('qty-minus', 'btn', 'btn-outline-secondary');

    container.insertBefore(minus, input);



    // وظائف الأزرار

    plus.addEventListener('click', function() {

      let val = parseFloat(input.value) || 0;

      const step = parseFloat(input.step) || 1;

      input.value = val + step;

      input.dispatchEvent(new Event('change'));

    });



    minus.addEventListener('click', function() {

      let val = parseFloat(input.value) || 0;

      const step = parseFloat(input.step) || 1;

      if (val - step >= 1) {

        input.value = val - step;

        input.dispatchEvent(new Event('change'));

      }

    });

  });

});
</script>

<?php

}



add_action( 'woocommerce_single_product_summary', 'custom_breadcrumbs_and_navigation', 1 );



function custom_breadcrumbs_and_navigation() {

    echo '<div class="product-top-nav mb-4">';



    // ✅ breadcrumbs

    echo '<div class="product-breadcrumb mb-2">';

    woocommerce_breadcrumb();

    echo '</div>';



    // ✅ prev/next navigation

    echo '<div class="product-post-navigation">';

    custom_next_prev_product_cards();

    echo '</div>';



    echo '</div>';

}







// عرض صورة وعنوان المنتج السابق والتالي في صفحة المنتج

// add_action( 'woocommerce_single_product_summary', 'custom_next_prev_product_cards', 2 );



function custom_next_prev_product_cards() {

    if ( ! is_product() ) return;



    global $post;



    $prev_product = get_adjacent_post( false, '', true );

    $next_product = get_adjacent_post( false, '', false );



    // رابط صفحة المتجر

    $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );



    echo '<div class="product-card-navigation">';



    // ← المنتج السابق

    if ( $prev_product && get_post_type( $prev_product ) === 'product' ) {

        $prev_id = $prev_product->ID;

        echo '<div class="product-box position-relative">';

        echo '<a href="' . get_permalink( $prev_id ) . '" class="product-card-nav prev-product"><i class="fa fa-arrow-right"></i>';

        echo '</a>';

        echo '<div class="product-card">';

        echo get_the_post_thumbnail( $prev_id, 'woocommerce_thumbnail', ['class' => 'img-fluid'] );

        echo '<span class="product-title">' . get_the_title( $prev_id ) . '</span>';

        echo '</div>';

        echo '</div>';

    } else {

        echo '<div style="flex:1;"></div>';

    }



    // 🔗 رابط المتجر

    echo '<a href="' . esc_url( $shop_page_url ) . '" class="product-card-nav shop-link">';

    echo '<span class="product-title"><i class="fa fa-shopping-cart"></i></span>';

    echo '</a>';



    // → المنتج التالي

    if ( $next_product && get_post_type( $next_product ) === 'product' ) {

        $next_id = $next_product->ID;

        echo '<div class="product-box position-relative">';

        echo '<a href="' . get_permalink( $next_id ) . '" class="product-card-nav next-product"><i class="fa fa-arrow-left"></i></a>';

        echo '<div class="product-card">';

        echo get_the_post_thumbnail( $next_id, 'woocommerce_thumbnail', ['class' => 'img-fluid'] );

        echo '<span class="product-title">' . get_the_title( $next_id ) . '</span>';

        echo '</div>';

        echo '</div>';

    } else {

        echo '<div style="flex:1;"></div>';

    }



    echo '</div>';

}



// إزالة التابات والمنتجات ذات الصلة من مكانها الافتراضي

remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );



// إعادة عرض التابات والمنتجات ذات الصلة في مكان مخصص

add_action( 'woocommerce_after_single_product', 'custom_output_tabs_and_related', 5 );



function custom_output_tabs_and_related() {

    echo '<div class="custom-tabs-and-related container mt-5">';



    // التابات

    woocommerce_output_product_data_tabs();



    // المنتجات ذات الصلة

    woocommerce_output_related_products();



    echo '</div>';

}


// add_filter('woocommerce_dropdown_variation_attribute_options_html222', function($html, $args) {
//   if (!empty($args['options'])) {
//     ob_start();
//     echo '<div class="variation-options">';
//     foreach ($args['options'] as $option) {
//       $checked = selected($args['selected'], $option, false);
//       echo '<label class="radio-label">';
//       echo '<input type="radio" name="' . esc_attr($args['attribute']) . '" value="' . esc_attr($option) . '" ' . $checked . ' />';
//       echo '<span>' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</span>';
//       echo '</label>';
//     }
//     echo '</div>';
//     $html = ob_get_clean();
//   }
//   return $html;
// }, 20, 2);
