<?php 

/**
 * Slider Custom Post Type
 */
function toplinewoocommerce_register_slider_post_type() {
    $labels = array(
        'name'               => _x( 'Sliders', 'post type general name', 'toplinewoocommerce' ),
        'singular_name'      => _x( 'Slider', 'post type singular name', 'toplinewoocommerce' ),
        'menu_name'          => _x( 'Sliders', 'admin menu', 'toplinewoocommerce' ),
        'name_admin_bar'     => _x( 'Slider', 'add new on admin bar', 'toplinewoocommerce' ),
        'add_new'            => _x( 'Add New', 'slider', 'toplinewoocommerce' ),
        'add_new_item'       => __( 'Add New Slider', 'toplinewoocommerce' ),
        'new_item'           => __( 'New Slider', 'toplinewoocommerce' ),
        'edit_item'         => __( 'Edit Slider', 'toplinewoocommerce' ),
        'view_item'         => __( 'View Slider', 'toplinewoocommerce' ),
        'all_items'         => __( 'All Sliders', 'toplinewoocommerce' ),
        'search_items'      => __( 'Search Sliders', 'toplinewoocommerce' ),
        'parent_item_colon' => __( 'Parent Sliders:', 'toplinewoocommerce' ),
        'not_found'         => __( 'No sliders found.', 'toplinewoocommerce' ),
        'not_found_in_trash'=> __( 'No sliders found in Trash.', 'toplinewoocommerce' )
    );
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'slider' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 5,
        'menu_icon'          => 'dashicons-format-gallery',
        'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
        'show_in_rest'       => true,
        'rest_base'          => 'sliders',
        'rest_controller_class' => 'WP_REST_Posts_Controller',
    );
    register_post_type( 'slider', $args );
}

add_action( 'init', 'toplinewoocommerce_register_slider_post_type' );

// Testimonial Custom Post Type
function toplinewoocommerce_register_testimonial_post_type() {
    $labels = array(
        'name'               => _x( 'Testimonials', 'post type general name', 'toplinewoocommerce' ),
        'singular_name'      => _x( 'Testimonial', 'post type singular name', 'toplinewoocommerce' ),
        'menu_name'          => _x( 'Testimonials', 'admin menu', 'toplinewoocommerce' ),
        'name_admin_bar'     => _x( 'Testimonial', 'add new on admin bar', 'toplinewoocommerce' ),
        'add_new'            => _x( 'Add New', 'testimonial', 'toplinewoocommerce' ),
        'add_new_item'       => __( 'Add New Testimonial', 'toplinewoocommerce' ),
        'new_item'           => __( 'New Testimonial', 'toplinewoocommerce' ),
        'edit_item'         => __( 'Edit Testimonial', 'toplinewoocommerce' ),
        'view_item'         => __( 'View Testimonial', 'toplinewoocommerce' ),
        'all_items'         => __( 'All Testimonials', 'toplinewoocommerce' ),
        'search_items'      => __( 'Search Testimonials', 'toplinewoocommerce' ),
        'parent_item_colon' => __( 'Parent Testimonials:', 'toplinewoocommerce' ),
        'not_found'         => __( 'No testimonials found.', 'toplinewoocommerce' ),
        'not_found_in_trash'=> __( 'No testimonials found in Trash.', 'toplinewoocommerce' )
    );
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'testimonial' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 6,
        'menu_icon'          => 'dashicons-testimonial',
        'supports'           => array( 'title', 'editor', 'thumbnail' ),
        'show_in_rest'       => true,
        'rest_base'          => 'testimonials',
        'rest_controller_class' => 'WP_REST_Posts_Controller',
    );
    register_post_type( 'testimonial', $args );
}
add_action( 'init', 'toplinewoocommerce_register_testimonial_post_type' );


/** * meta box for testimonial post type
 */
function toplinewoocommerce_testimonial_meta_box() {
    add_meta_box(
        'testimonial_meta_box',
        __( 'تفاصيل الشهادة', 'toplinewoocommerce' ),
        'toplinewoocommerce_testimonial_meta_box_callback',
        'testimonial',
        'normal',
        'high'
    );
}
add_action( 'add_meta_boxes', 'toplinewoocommerce_testimonial_meta_box' );

function toplinewoocommerce_testimonial_meta_box_callback( $post ) {
    wp_nonce_field( 'toplinewoocommerce_save_testimonial_meta_box_data', 'toplinewoocommerce_testimonial_meta_box_nonce' );
    $position = get_post_meta( $post->ID, '_testimonial_position', true );
    ?>
<p>
  <label for="testimonial_position">المنصب</label>
  <input type="text" id="testimonial_position" name="testimonial_position"
    value="<?php echo esc_attr( $position ); ?>" />
</p>
<?php
}
function toplinewoocommerce_save_testimonial_meta_box_data( $post_id ) {
    if ( ! isset( $_POST['toplinewoocommerce_testimonial_meta_box_nonce'] ) ) {
        return;
    }
    if ( ! wp_verify_nonce( $_POST['toplinewoocommerce_testimonial_meta_box_nonce'], 'toplinewoocommerce_save_testimonial_meta_box_data' ) ) {
        return;
    }
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
    if ( isset( $_POST['testimonial_position'] ) ) {
        $position = sanitize_text_field( $_POST['testimonial_position'] );
        update_post_meta( $post_id, '_testimonial_position', $position );
    }
}
add_action( 'save_post', 'toplinewoocommerce_save_testimonial_meta_box_data' );
function toplinewoocommerce_admin_testimonial_css() {
    $screen = get_current_screen();
    if ( isset( $screen->post_type ) && 'testimonial' === $screen->post_type ) {
        echo '<style>
                #testimonial_position {
                    width: 50%;
                    background-color: #f5f5f5;
                    padding: 5px;
                    border: 1px solid #ccc;
                }
              </style>';
    }
}
add_action( 'admin_head', 'toplinewoocommerce_admin_testimonial_css' );


// partners

function toplinewoocommerce_register_partner_post_type() {
    $labels = array(
        'name'               => _x( 'Partners', 'post type general name', 'toplinewoocommerce' ),
        'singular_name'      => _x( 'Partner', 'post type singular name', 'toplinewoocommerce' ),
        'menu_name'          => _x( 'Partners', 'admin menu', 'toplinewoocommerce' ),
        'name_admin_bar'     => _x( 'Partner', 'add new on admin bar', 'toplinewoocommerce' ),
        'add_new'            => _x( 'Add New', 'partner', 'toplinewoocommerce' ),
        'add_new_item'       => __( 'Add New Partner', 'toplinewoocommerce' ),
        'new_item'           => __( 'New Partner', 'toplinewoocommerce' ),
        'edit_item'         => __( 'Edit Partner', 'toplinewoocommerce' ),
        'view_item'         => __( 'View Partner', 'toplinewoocommerce' ),
        'all_items'         => __( 'All Partners', 'toplinewoocommerce' ),
        'search_items'      => __( 'Search Partners', 'toplinewoocommerce' ),
        'parent_item_colon' => __( 'Parent Partners:', 'toplinewoocommerce' ),
        'not_found'         => __( 'No partners found.', 'toplinewoocommerce' ),
        'not_found_in_trash'=> __( 'No partners found in Trash.', 'toplinewoocommerce' )
    );
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'partner' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 7,
        'menu_icon'          => 'dashicons-businessman',
        'supports'           => array( 'title', 'thumbnail' ),
        'show_in_rest'       => true,
        'rest_base'          => 'partners',
        'rest_controller_class' => 'WP_REST_Posts_Controller',
    );
    register_post_type( 'partner', $args );
}
add_action( 'init', 'toplinewoocommerce_register_partner_post_type' );