<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package toplineWooCommerce
 */

get_header();
?>

<main id="primary" class="site-main">

  <?php if ( have_posts() ) : ?>

  <header class="page-header">
    <div class="container">
      <h1 class="page-title">نتائج البحث عن: <?php echo get_search_query(); ?></h1>
    </div>
  </header><!-- .page-header -->
  <div class="container">

    <?php
			/* Start the Loop */
			echo '<div class="products-grid">';
			while ( have_posts() ) :
				the_post();
				
				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				*/
				get_template_part( 'template-parts/content', 'search' );
				
			endwhile;
			echo '</div>';
			
			the_posts_navigation();
			
			else :
				
				get_template_part( 'template-parts/content', 'none' );
				
			endif;
			?>

  </div>
</main><!-- #main -->

<?php
get_sidebar();
get_footer();